ALTER TABLE transfer.users_in_dogsleds RENAME TO old_users_in_dogsleds;

DROP INDEX
    transfer.i_users_in_dogsleds_by_husky_id_prioretized_pending,
    transfer.i_users_in_dogsleds_by_husky_id_in_transfer;

CREATE TABLE transfer.users_in_dogsleds (
    uid         bigint,
    suid        bigint,
    login       text,

    from_db     text,
    to_db       text,

    disallow_inited       boolean NOT NULL DEFAULT false,
    fill_change_log       boolean NOT NULL DEFAULT false,
    update_mail_migration boolean NOT NULL DEFAULT false,

    priority    smallint NOT NULL DEFAULT 0,
    husky_id    integer,

    tries       smallint NOT NULL DEFAULT 0,
    status      transfer.user_status     NOT NULL DEFAULT 'pending',
    last_update timestamp with time zone NOT NULL DEFAULT current_timestamp,
    try_notices text[],

    CONSTRAINT check_tries CHECK (tries >= 0),
    CONSTRAINT check_status CHECK (status = 'pending' OR husky_id IS NOT NULL),
    CONSTRAINT check_userinfo CHECK (
            uid IS NOT NULL
         OR suid IS NOT NULL
         OR login IS NOT NULL
    ),

    CONSTRAINT fk_users_in_dogsleds_and_huskies FOREIGN KEY (husky_id)
        REFERENCES transfer.huskies ON DELETE RESTRICT
);

COMMENT ON COLUMN transfer.users_in_dogsleds.priority
    IS 'lowest priority = first to transfer';

CREATE UNIQUE INDEX i_users_in_dogsleds_by_uid_not_null
    ON transfer.users_in_dogsleds (uid)
 WHERE uid IS NOT NULL;

CREATE INDEX i_users_in_dogsleds_by_husky_id_prioretized_pending
    ON transfer.users_in_dogsleds (husky_id, priority, last_update)
 WHERE status = 'pending';

CREATE INDEX i_users_in_dogsleds_by_husky_id_uid_in_transfer
    ON transfer.users_in_dogsleds (husky_id, uid)
 WHERE status = 'in_transfer';

INSERT INTO transfer.users_in_dogsleds (
    SELECT uid, null, null, null, to_db,
           disallow_inited, fill_change_log, update_mail_migration,
           priority, husky_id,
           tries, status, last_update, try_notices
    FROM transfer.old_users_in_dogsleds
);
