CREATE TABLE shards.deleted_users(
    uid bigint NOT NULL,
    shard_id integer NOT NULL REFERENCES shards.shards (shard_id) ON DELETE RESTRICT,
    data jsonb,
    CONSTRAINT pk_deleted_users_uid PRIMARY KEY (uid),
    CONSTRAINT limit_shards_deleted_users_data CHECK (length(data::text) <= 64)
);

CREATE FUNCTION shards.check_uid_for_deleted_users_is_not_in_users()
RETURNS TRIGGER LANGUAGE plpgsql AS $$
BEGIN
    IF (SELECT count(1) FROM shards.users WHERE uid=NEW.uid) > 0 THEN
        RAISE EXCEPTION 'uid % is in shards.users', NEW.uid;
    END IF;
    RETURN NEW;
END;
$$;

CREATE TRIGGER tg_deleted_users_not_in_users
    BEFORE INSERT ON shards.deleted_users
    FOR EACH ROW EXECUTE PROCEDURE shards.check_uid_for_deleted_users_is_not_in_users();

CREATE FUNCTION shards.check_uid_for_users_is_not_in_deleted_users()
RETURNS TRIGGER LANGUAGE plpgsql AS $$
BEGIN
    IF (SELECT count(1) FROM shards.deleted_users WHERE uid=NEW.uid) > 0 THEN
        RAISE EXCEPTION 'uid % is in shards.deleted_users', NEW.uid;
    END IF;
    RETURN NEW;
END;
$$;

CREATE TRIGGER tg_users_not_in_deleted_users
    BEFORE INSERT ON shards.users
    FOR EACH ROW EXECUTE PROCEDURE shards.check_uid_for_users_is_not_in_deleted_users();
