CREATE SEQUENCE shards.domain_org_id START WITH 1 INCREMENT BY 1;

CREATE TABLE shards.domains_organizations (
    domain_org_id bigint NOT NULL DEFAULT nextval('shards.domain_org_id'),
    domain_id bigint,
    org_id bigint,
    shard_id integer NOT NULL
        REFERENCES shards.shards (shard_id) ON DELETE RESTRICT,

    CONSTRAINT pk_domains_organizations_domain_id PRIMARY KEY (domain_org_id),
    CONSTRAINT uk_domains_organizations_domain_id UNIQUE (domain_id),
    CONSTRAINT uk_domains_organizations_org_id UNIQUE (org_id)
);

CREATE UNIQUE INDEX uk_domain_id_for_domain
    ON shards.domains_organizations (domain_id)
 WHERE domain_id IS NOT NULL;

CREATE UNIQUE INDEX uk_org_id_for_organization
    ON shards.domains_organizations (org_id)
 WHERE org_id IS NOT NULL;
