CREATE OR REPLACE FUNCTION code.find_smlar_subject(
    i_subject text,
    i_sender_domain text
) RETURNS TABLE(stable_sign bigint, subject text, similarity real)
  LANGUAGE SQL STABLE AS $$
select stable_sign,
       subject,
       smlar(lexemes, tsvector_to_array(to_tsvector('english', i_subject))) as similarity
  from (
    select *,
           tsvector_to_array(to_tsvector('english', subject)) lexemes,
           cnt
      from (
        select t.*,
               st.value->>0 as subject,
               (st.value->>1)::integer as cnt
          from sherlock.templates t,
               jsonb_array_elements(info->'subject_top') as st
         where constants.sender_domain(sender) = i_sender_domain
           and detemple_id IN (
            select detemple_id
              from sherlock.detemples
            ORDER BY loaded_at DESC
            LIMIT 1
        )
    ) t
) t
order by similarity desc;
$$
