CREATE EXTENSION IF NOT EXISTS intarray;
CREATE EXTENSION IF NOT EXISTS smlar;

CREATE SCHEMA sherlock;

CREATE TABLE sherlock.template_bodies (
    stable_sign bigint primary key,
    sign        integer[],
    highfreq    boolean default false,
    chunks      jsonb
);

CREATE INDEX i_template_sign_hf
    ON sherlock.template_bodies
 USING gin (sign _int4_sml_ops) WITH (FASTUPDATE=OFF)
 WHERE highfreq;

CREATE INDEX i_template_sign_not_hf
    ON sherlock.template_bodies
 USING gin (sign _int4_sml_ops) WITH (FASTUPDATE=OFF)
 WHERE NOT highfreq;

CREATE INDEX i_template_bodies_hf
    ON sherlock.template_bodies (stable_sign)
 WHERE highfreq;

CREATE TABLE sherlock.detemples (
    detemple_id serial primary key,
    loaded_at   timestamp with time zone default now(),
    info        jsonb
);

CREATE TABLE sherlock.templates (
    stable_sign bigint,

    detemple_id integer NOT NULL,
    sender      text COLLATE "C" NOT NULL,
    job_id      smallint NOT NULL,
    template_id smallint NOT NULL,

    main_token  text,
    match_count integer,
    highfreq    boolean default false,

    info        jsonb,

    CONSTRAINT pk_templates UNIQUE (detemple_id, sender, job_id, template_id),

    CONSTRAINT fk_templates_on_detemples FOREIGN KEY (detemple_id)
        REFERENCES sherlock.detemples ON DELETE CASCADE,
    CONSTRAINT fk_templates_on_template_bodies FOREIGN KEY (stable_sign)
        REFERENCES sherlock.template_bodies ON DELETE RESTRICT
);

CREATE INDEX i_sender_domain
    ON sherlock.templates (constants.sender_domain(sender));
