CREATE DOMAIN code.org_id AS bigint
    CONSTRAINT org_id_not_null_and_positive
        CHECK (VALUE IS NOT NULL AND VALUE > 0);


CREATE DOMAIN code.search_id AS bigint
    CONSTRAINT search_id_not_null_and_greater_than_zero
        CHECK (VALUE IS NOT NULL AND VALUE > 0);


CREATE DOMAIN code.uid AS bigint
    CONSTRAINT uid_not_null_and_positive
        CHECK (VALUE IS NOT NULL AND VALUE > 0);

CREATE DOMAIN code.uids AS bigint[]
    CONSTRAINT uids_not_empty
        CHECK (
            VALUE IS NOT NULL
            AND
            cardinality(VALUE) > 0
        );
