CREATE OR REPLACE FUNCTION code.log_action(
    i_type            spaniel.action_history_type,
    i_request_info    code.request_info,
    i_info            jsonb DEFAULT NULL
) RETURNS void AS $$
DECLARE
    v_action_id bigint := nextval('spaniel.action_history_seq');
BEGIN
    INSERT INTO spaniel.action_history (
        org_id,
        action_id,
        admin_uid,
        type,
        info
    ) SELECT
        i_request_info.org_id,
        v_action_id,
        i_request_info.uid,
        i_type,
        i_info;
END
$$ LANGUAGE plpgsql;
