CREATE OR REPLACE FUNCTION code.archive_search(
    i_search_id      code.search_id,
    request_info     code.request_info
) RETURNS text AS $$
DECLARE
    current_state spaniel.task_state;

BEGIN
    SELECT state
      FROM spaniel.searches
     WHERE org_id = request_info.org_id AND search_id = i_search_id
      INTO current_state;

    IF current_state IS NULL THEN
        RETURN 'search_is_missing';
    ELSIF current_state = 'in_progress' THEN
        RETURN 'wrong_state';
    END IF;

    DELETE FROM spaniel.search_results
     WHERE org_id = request_info.org_id AND search_id = i_search_id;

    UPDATE spaniel.searches
       SET state = 'archived',
           updated = current_timestamp
     WHERE org_id = request_info.org_id AND search_id = i_search_id;

    RETURN NULL;
END;
$$ LANGUAGE plpgsql;
