CREATE OR REPLACE FUNCTION code.cache_search_results(
    i_search_id       code.search_id,
    i_search_results  code.search_result[],
    request_info      code.request_info
) RETURNS text AS $$
BEGIN
    INSERT INTO spaniel.search_results (org_id, search_id, uid, id, received_date)
    SELECT request_info.org_id, i_search_id, sr.uid, sr.id, to_timestamp(sr.received_date)
      FROM unnest(i_search_results) AS sr
        ON CONFLICT DO NOTHING;

    UPDATE spaniel.searches
       SET updated = current_timestamp
     WHERE org_id = request_info.org_id
       AND search_id = i_search_id;

    RETURN NULL;
END;
$$ LANGUAGE plpgsql;
