CREATE OR REPLACE FUNCTION code.create_search(
    i_search_id      code.search_id,
    i_query          jsonb,
    i_name           text,
    i_requested_uids code.uids,
    i_date_from      timestamptz,
    i_date_to        timestamptz,
    request_info     code.request_info
) RETURNS text AS $$
DECLARE
    max_search_id     code.search_id := (impl.acquire_current_serials(request_info.org_id)).next_search_id;
BEGIN
    IF i_search_id >= max_search_id THEN
        RETURN 'search_id_not_reserved';
    END IF;

    INSERT INTO spaniel.searches (org_id, search_id, admin_uid, requested_uids, query, name, date_from, date_to, request_id)
    VALUES (request_info.org_id, i_search_id, request_info.uid, i_requested_uids, i_query, i_name, i_date_from, i_date_to, request_info.request_id)
        ON CONFLICT DO NOTHING;

    IF NOT FOUND THEN
        RETURN 'unique_violation';
    END IF;

    PERFORM code.log_action(
        i_type          => 'create_search',
        i_request_info  => request_info,
        i_info          => json_build_object('create_search', json_build_object('search_id', i_search_id))::jsonb
    );

    RETURN NULL;
END;
$$ LANGUAGE plpgsql;
