CREATE OR REPLACE FUNCTION code.fail_search(
    i_search_id       code.search_id,
    i_notice          text,
    i_request_info    code.request_info
) RETURNS void AS $$
BEGIN
    UPDATE spaniel.searches
       SET updated = current_timestamp,
           state = 'error',
           notice = i_notice
     WHERE search_id = i_search_id AND state = 'in_progress' AND org_id = i_request_info.org_id;
END;
$$ LANGUAGE plpgsql;
