CREATE OR REPLACE FUNCTION code.fill_search(
    i_search_id       code.search_id,
    i_search_results  code.search_result[],
    i_target_state    spaniel.task_state,
    request_info      code.request_info
) RETURNS text AS $$
DECLARE
    current_state      spaniel.task_state;
    min_received_date  bigint;

BEGIN
    SELECT state
      FROM spaniel.searches
     WHERE org_id = request_info.org_id AND search_id = i_search_id
      INTO current_state;

    IF current_state IS NULL THEN
        RETURN 'search_is_missing';
    ELSIF current_state != 'in_progress' THEN
        RETURN 'wrong_state';
    END IF;

    IF NOT i_target_state IN ('complete', 'partially_complete') THEN
        RETURN 'wrong_state';
    END IF;

    INSERT INTO spaniel.search_results (org_id, search_id, uid, id, received_date)
    SELECT request_info.org_id, i_search_id, sr.uid, sr.id, to_timestamp(sr.received_date)
      FROM unnest(i_search_results) AS sr
        ON CONFLICT DO NOTHING;

    SELECT min(received_date)
      FROM unnest(i_search_results)
      INTO min_received_date;

    UPDATE spaniel.searches
       SET min_search_date = to_timestamp(min_received_date)
     WHERE org_id = request_info.org_id
       AND search_id = i_search_id
       AND (min_search_date IS NULL OR min_search_date > to_timestamp(min_received_date));

    UPDATE spaniel.searches
       SET state = i_target_state,
           updated = current_timestamp
     WHERE org_id = request_info.org_id
       AND search_id = i_search_id;

    RETURN NULL;
END;
$$ LANGUAGE plpgsql;
