CREATE OR REPLACE FUNCTION code.reserve_search_id(
    i_org_id           code.org_id
) RETURNS code.search_id AS $$
DECLARE
    current_search_id code.search_id := (impl.acquire_current_serials(i_org_id)).next_search_id;
BEGIN
    UPDATE spaniel.serials
       SET next_search_id = next_search_id + 1
     WHERE org_id = i_org_id;
    RETURN current_search_id;
END;
$$ LANGUAGE plpgsql;
