CREATE OR REPLACE FUNCTION code.activate_organization(
      i_org_id        code.org_id
) RETURNS void AS $$
BEGIN
    PERFORM *
       FROM spaniel.organizations
      WHERE org_id = i_org_id;

    IF found THEN
        UPDATE spaniel.organizations
           SET state = 'active',
               doom_date = NULL
         WHERE org_id = i_org_id
           AND state != 'active';
    ELSE
        INSERT INTO spaniel.organizations (org_id, state)
        VALUES (i_org_id, 'active')
        ON CONFLICT DO NOTHING;

        INSERT INTO spaniel.serials (org_id, next_search_id)
        VALUES (i_org_id, 1)
        ON CONFLICT DO NOTHING;

        INSERT INTO spaniel.organization_uids (org_id, uid)
        VALUES (i_org_id, '{}')
        ON CONFLICT DO NOTHING;
    END IF;
END
$$ LANGUAGE plpgsql;
