CREATE OR REPLACE FUNCTION code.register_task_id(
    i_org_id           code.org_id,
    i_task_id          bigint
) RETURNS boolean AS $$
BEGIN
    PERFORM *
       FROM spaniel.tasks
      WHERE org_id = i_org_id
        AND task_id = i_task_id;

    IF found THEN
        RETURN true;
    END IF;
    
    BEGIN
        INSERT INTO spaniel.tasks (org_id, task_id)
        VALUES (i_org_id, i_task_id);
    EXCEPTION
        WHEN unique_violation THEN
            RETURN false;
    END;

    RETURN true;
END;
$$ LANGUAGE plpgsql;
