from mail.devpack.lib.components.postgres import Postgres


class SpanielDb(Postgres):
    NAME = "spanieldb"

    before_all_prefixes = [
        'resfs/file/mail/pg/spanieldb/devpack/extensions.sql',
    ]

    after_all_prefixes = [
        'resfs/file/mail/pg/spanieldb/impl',
        'resfs/file/mail/pg/spanieldb/code',
        'resfs/file/mail/pg/spanieldb/grants',
        'resfs/file/mail/pg/spanieldb/devpack/grants.sql',
    ]
    migration_prefixes = [
        'resfs/file/mail/pg/spanieldb/migrations',
    ]
    snapshot_sql_files = [
        'resfs/file/mail/pg/spanieldb/spaniel.sql',
    ]

    def __init__(self, env, _):
        users = [
            'spanieldb',
            'spaniel',
            'tech',
        ]
        self.init_from_conf(env.get_config(), 'spanieldb', users)
