CREATE OR REPLACE FUNCTION impl.acquire_current_serials(
    i_org_id bigint
) RETURNS spaniel.serials AS $$
DECLARE
    v_row spaniel.serials;
BEGIN
    SELECT *
      FROM spaniel.serials
     WHERE org_id = i_org_id
       FOR NO KEY UPDATE
      INTO v_row;
    IF NOT found THEN
        RAISE EXCEPTION 'No serials selected, org_id: %', i_org_id
              USING HINT = 'Probably organization doesn''t exists',
                   TABLE = 'spaniel.serials';
    END IF;

    RETURN v_row;
END
$$ LANGUAGE plpgsql;
