CREATE SCHEMA IF NOT EXISTS spaniel;

CREATE TYPE spaniel.task_state AS ENUM (
    'in_progress',
    'complete',
    'archived',
    'error'
);

CREATE TABLE spaniel.organizations (
    org_id               bigint   NOT NULL PRIMARY KEY
);

CREATE TABLE spaniel.serials (
    org_id               bigint   NOT NULL PRIMARY KEY,
    next_search_id       bigint   NOT NULL,

    CONSTRAINT fk_serials_organizations FOREIGN KEY (org_id) REFERENCES spaniel.organizations ON DELETE CASCADE
);

CREATE TABLE spaniel.searches (
    org_id              bigint    NOT NULL,
    search_id           bigint    NOT NULL,
    admin_uid           bigint    NOT NULL,

    requested_uids      bigint[]  NOT NULL,
    query               jsonb     NOT NULL,

    state               spaniel.task_state NOT NULL DEFAULT 'in_progress',
    name                text,
    notice              text,
    date_from           timestamptz NOT NULL,
    date_to             timestamptz NOT NULL,
    created             timestamptz NOT NULL DEFAULT current_timestamp,
    updated             timestamptz NOT NULL DEFAULT current_timestamp,

    CONSTRAINT pk_search PRIMARY KEY (org_id, search_id),
    CONSTRAINT fk_search_organizations FOREIGN KEY (org_id) REFERENCES spaniel.organizations ON DELETE CASCADE
);

CREATE TABLE spaniel.search_results (
    org_id        bigint      NOT NULL,
    search_id     bigint      NOT NULL,
    uid           bigint      NOT NULL,
    id            bigint      NOT NULL,
    received_date timestamptz NOT NULL,

    CONSTRAINT pk_search_results PRIMARY KEY (org_id, search_id, uid, id),
    CONSTRAINT fk_search_results_search FOREIGN KEY (org_id, search_id) REFERENCES spaniel.searches ON DELETE CASCADE
);
