CREATE TYPE spaniel.action_history_type AS ENUM (
    'create_search',
    'send_share'
);

CREATE SEQUENCE spaniel.action_history_seq START WITH 1 INCREMENT BY 1 CYCLE;

CREATE TABLE spaniel.action_history (
    org_id      bigint                      NOT NULL,
    action_id   bigint                      NOT NULL DEFAULT nextval('spaniel.action_history_seq'),
    admin_uid   bigint                      NOT NULL,
    date        timestamptz                 NOT NULL DEFAULT current_timestamp,
    type        spaniel.action_history_type NOT NULL,
    info        jsonb,

    CONSTRAINT pk_action_history PRIMARY KEY (org_id, action_id),
    CONSTRAINT fk_action_history_organizations FOREIGN KEY (org_id) REFERENCES spaniel.organizations ON DELETE CASCADE
);
