CREATE TYPE spaniel.organization_state AS ENUM (
    'active',
    'disabled'
);

ALTER TABLE spaniel.organizations
    ADD COLUMN state      spaniel.organization_state NOT NULL DEFAULT 'active',
    ADD COLUMN doom_date  timestamptz,
    ADD COLUMN created    timestamptz NOT NULL DEFAULT current_timestamp,

    ADD CONSTRAINT doom_date_only_on_disabled CHECK (
           (state = 'active'   AND doom_date IS NULL)
        OR (state = 'disabled' AND doom_date IS NOT NULL)
    )
;

ALTER TABLE spaniel.organizations ALTER COLUMN state DROP DEFAULT;