#pragma once

#include <boost/spirit/include/qi.hpp>
#include <boost/spirit/include/phoenix_core.hpp>
#include <pgg/chrono.h>

/**
 * Templates specializations for the qi::attr_cast
 */
namespace boost {
namespace spirit {
namespace traits {

/**
 * Template specialoization for cast from ulong_ to Milliseconds
 */
template <>
struct transform_attribute<pgg::Milliseconds, unsigned long, qi::domain> {
    typedef unsigned long type;

    static type pre(pgg::Milliseconds& d) { return static_cast<type>(d.count()); }

    static void post(pgg::Milliseconds& val, type const& attr) {
        val = pgg::Milliseconds(attr);
    }

    static void fail(pgg::Milliseconds&) {}
};

} // namespace traits
} // namespace spirit
} // namespace boost
