#pragma once

#include <map>
#include <internal/query_conf/spirit.h>

namespace pgg {
namespace query {
namespace conf {

template<typename Iterator>
struct ErrorHandler {

    typedef void result_type;

    struct LineStart {
        Iterator pos;
        std::size_t lineNumber;
        LineStart(Iterator pos, std::size_t lineNumber)
        : pos(pos), lineNumber(lineNumber) {}
    };

    Iterator findEol(Iterator begin, Iterator where) const {
        return std::find(begin, where, '\n');
    }

    LineStart findLineStart(Iterator begin, Iterator where) const {
        Iterator pos = begin;
        std::size_t lineNo = 1;
        for (Iterator i = findEol(begin, where); i != where; i = findEol(i, where)) {
            pos = ++i;
            ++lineNo;
        }
        return LineStart(pos, lineNo);
    }

    template<class I>
    void operator()(Iterator begin, Iterator end, Iterator where,
            I const& info) const {
        LineStart lineStart = findLineStart(begin, where);
        Iterator lineEnd = findEol(where, end);
        const auto colNumber = static_cast<std::size_t>(where - lineStart.pos);

        std::stringstream out;
        out << "expecting " << info
                << " at line " << lineStart.lineNumber
                << ", col " << colNumber + 1 << ": " << std::endl
                << boost::iterator_range<Iterator>(lineStart.pos, lineEnd)
                << std::endl << std::string(colNumber, '~') << '^' << std::endl;

        throw std::runtime_error(out.str());
    }
};

} // namespace conf
} // namespace query
} // namespace pgg
