#pragma once

#include <apq/connection_pool.hpp>
#include <pgg/chrono.h>
#include <pgg/database/io_service.h>
#include <pgg/connection_pool_settings.h>

namespace pgg {
namespace database {

class Endpoint {
public:
    Endpoint(IoServicePtr io, const std::string& connInfo, const ConnectionPoolSettings & settings)
    : ios_(io), pool_(ios()), queryTimeout_(settings.queryTimeout), connInfo_(connInfo) {
        pool().set_conninfo( connectionInfo() );
        pool().set_limit( settings.maxConnections );
        pool().set_connect_timeout(settings.connectTimeout);
        pool().set_queue_timeout(settings.queueTimeout);
        pool().set_async_resolve(settings.asyncResolve);
        pool().set_ipv6_only(settings.ipv6Only);
    }

    boost::asio::io_service & ios() const { return ios_->ios(); }
    apq::connection_pool & pool() { return pool_; }
    Duration queryTimeout() const { return queryTimeout_;}
    const std::string & connectionInfo() const { return connInfo_;}

    using Stats = apq::connection_pool::stats;
    Stats getStats() const { return  pool_.get_stats(); }

private:
    IoServicePtr ios_;
    apq::connection_pool pool_;
    Duration queryTimeout_;
    std::string connInfo_;
};

typedef boost::shared_ptr<Endpoint> EndpointPtr;

inline EndpointPtr createEndpoint(IoServicePtr io, const std::string& connInfo,
        const ConnectionPoolSettings & settings) {
    return boost::make_shared<Endpoint>(io, connInfo, settings);
}

} // namespace database
} // namespace pgg
