#pragma once

#include <boost/thread.hpp>
#include <boost/asio.hpp>
#include <boost/shared_ptr.hpp>

namespace pgg {
namespace database {

struct IoService {
    virtual ~IoService() {}
    virtual boost::asio::io_service & ios() = 0;
};

struct IoServiceWithPoolBase {
    boost::asio::io_service ios_;
    boost::thread_group workers_;
    ~IoServiceWithPoolBase() { workers_.join_all(); }
};

class IoServiceWithPool : private IoServiceWithPoolBase, public IoService {
public:
    IoServiceWithPool( std::size_t workerCount ) : keepThreadsRunning(ios_) {
        while(workerCount--) {
            workers_.create_thread(boost::bind(&boost::asio::io_service::run, &ios()));
        }
    }
    boost::asio::io_service & ios() override {
        return ios_;
    }
private:
    boost::asio::io_service::work keepThreadsRunning;
};

class ExternalIoService : public IoService {
public:
    ExternalIoService( boost::asio::io_service & ios ) : ios_(ios) {}

    boost::asio::io_service & ios() override { return ios_; }
private:
    boost::asio::io_service & ios_;
};

typedef boost::shared_ptr<IoService> IoServicePtr;

} // namespace database
} // namespace pgg
