#pragma once

#include <pgg/database/database.h>

namespace pgg {
namespace database {

template <typename Handler>
void forwardError(Handler&& h, error_code res) {
    h(res, {});
}

inline void forwardError(Connection::UpdateHandler h, error_code res) {
    h(res, 0);
}

inline void forwardError(Connection::ExecuteHandler h, error_code res) {
    h(res);
}

} // namespace database
} // namespace pgg
