#pragma once

#include <pgg/database/performer/context.h>

namespace pgg {
namespace database {

template<typename HandlerT>
class Handler {
    using ContextPtr = std::shared_ptr<Context<HandlerT>>;
public:

    const apq::query& query() const { return ctx->query(); }

    template<typename... ArgsT>
    void operator()(ArgsT&&... args) const {
        ctx->handle(std::move(args)...);
    }

    Handler(ContextPtr ctx) : ctx(std::move(ctx)) { }
private:
    ContextPtr ctx;
};

template<typename HandlerT>
Handler<HandlerT> makeHandler(HandlerT h, const Query& q, LoggingAttributes logAttrs,
                              EndpointPtr endpoint) {
    auto context = std::make_shared<Context<HandlerT>>(q, std::move(h), std::move(logAttrs),
                                                       std::move(endpoint));
    return Handler<HandlerT>(std::move(context));
}

} // namespace database
} // namespace pgg
