#pragma once

#include <pgg/logging.h>
#include <apq/query.hpp>
#include <sstream>

namespace pgg {
namespace database {

inline std::ostream & streamValues(std::ostream & s, const apq::query & query){
    for(std::size_t i = 0; i!=query.values_.size(); ++i) {
        s << "\t$" << i+1 << '=';
        query.values_[i].second->stream(s) << std::endl;
    }
    return s;
}

inline std::vector<std::string> extractValues(const apq::query& query) {
    std::vector<std::string> values;
    values.reserve(query.values_.size());

    std::ostringstream os;
    for (const auto& pair : query.values_) {
        pair.second->stream(os);
        values.push_back(os.str());
        os.str("");
        os.clear();
    }

    return values;
}

inline std::ostream & streamQuery(std::ostream & s, const apq::query & query){
    s << "query:" << std::endl << query.text_ << ';' << std::endl;
    s << "values:" << std::endl;
    return streamValues(s, query) << std::endl;
}

inline std::string toString(const apq::query & query) {
    std::ostringstream s;
    streamQuery(s, query);
    return s.str();
}

} // namespace database
} // namespace pgg
