#pragma once

#include <boost/shared_ptr.hpp>
#include <boost/asio.hpp>
#include <pgg/connection_pool_settings.h>

namespace pgg {

namespace database {
class ConnectionPool;
}

using ConnectionPoolPtr = boost::shared_ptr<database::ConnectionPool>;

class ConnectionPoolFactory {
    std::size_t workersCount_ = 8;
    boost::asio::io_service * ioService_ = nullptr;
    Duration dnsCacheTTL_ = Duration::zero();
    std::size_t limit_ = 0;
    ConnectionPoolSettings settings_;
public:
    ConnectionPoolFactory& limit(std::size_t v) {
        limit_ = v;
        return *this;
    }
    ConnectionPoolFactory& workersCount(std::size_t v) {
        workersCount_ = v;
        return *this;
    }
    ConnectionPoolFactory& ioService(boost::asio::io_service & v) {
        ioService_ = &v;
        return *this;
    }
    ConnectionPoolFactory& dnsCacheTTL(Duration v) {
        dnsCacheTTL_ = v;
        return *this;
    }
    ConnectionPoolFactory& asyncResolve(bool enabled) {
        settings_.asyncResolve = enabled;
        return *this;
    }
    ConnectionPoolFactory& ipv6Only(bool enabled) {
        settings_.ipv6Only = enabled;
        return *this;
    }
    ConnectionPoolFactory& connectTimeout(Duration v) {
        settings_.connectTimeout = v;
        return *this;
    }
    ConnectionPoolFactory& queueTimeout(Duration v) {
        settings_.queueTimeout = v;
        return *this;
    }
    ConnectionPoolFactory& queryTimeout(Duration v) {
        settings_.queryTimeout = v;
        return *this;
    }
    ConnectionPoolFactory& maxConnections(std::size_t v) {
        settings_.maxConnections = v;
        return *this;
    }

    ConnectionPoolPtr product() const;
};

} // namespace pgg
