#pragma once

#include <pgg/database/pool_factory.h>
#include <chrono>

namespace pgg {
namespace statistic {

struct ConnectionStats
{
    std::size_t freeConnections = 0;
    std::size_t busyConnections = 0;
    std::size_t pendingConnections = 0;
    std::size_t maxConnections = 0;
    std::size_t queueSize = 0;

    std::chrono::microseconds averageRequestRoundtrip = std::chrono::microseconds(0);
    std::chrono::microseconds averageRequestDbLatency = std::chrono::microseconds(0);
    std::chrono::microseconds averageWaitTime = std::chrono::microseconds(0);

    std::uint64_t droppedTimedOut = 0;
    std::uint64_t droppedFailed = 0;
    std::uint64_t droppedBusy = 0;
    std::uint64_t droppedWithResult = 0;
};

using ConnId = std::string;
using ConnectionPoolStats = std::vector<std::pair<ConnId, ConnectionStats>>;

ConnectionPoolStats getPoolStats(const database::ConnectionPool& pool);

} // namespace statistic
} // namespace pgg
