#pragma once

#include <iostream>

namespace pgg {

template <typename Handler>
void noException(Handler&& handler) noexcept {
    try {
        handler();
    } catch (const std::exception& e) {
        std::cerr << __PRETTY_FUNCTION__ << ": unexpected exception: " << e.what() << std::endl;
    } catch (...) {
        std::cerr << __PRETTY_FUNCTION__ << ": unexpected unknown exception" << std::endl;
    }
}

} // namespace pgg
