#pragma once

#include <sstream>
#include <stdexcept>
#include <boost/numeric/conversion/cast.hpp>

namespace pgg {

struct NumericCastError : std::logic_error {
    template <class T>
    NumericCastError(T value, const char* function, const char* valueName, const char* error)
        : std::logic_error(makeMessage(value, function, valueName, error)) {}

    template <class T>
    static std::string makeMessage(T value, const char* function, const char* valueName, const char* error) {
        std::ostringstream stream;
        stream << "Bad numeric cast of " << valueName << " which is " << value << " in " << function << ": " << error;
        return stream.str();
    }
};

template <class R, class T>
R numericCast(T value, const char* functionName, const char* valueName) {
    try {
        return boost::numeric_cast<R>(value);
    } catch (const boost::bad_numeric_cast &error) {
        throw NumericCastError(value, functionName, valueName, error.what());
    }
}

} // namespace pgg

#define PGG_NUMERIC_CAST(Type, value) \
    ::pgg::numericCast<Type>(value, __PRETTY_FUNCTION__, #value)
