#pragma once

#include <string>
#include <boost/shared_ptr.hpp>
#include <pgg/chrono.h>

namespace pgg {
namespace profiling {

class Log {
public:
    virtual ~Log() {};
    virtual void write( const std::string & operation,
            const std::string & info, Duration duration ) const = 0;
};

using LogPtr = boost::shared_ptr<Log>;

inline void write(const Log & log, const Time & start, const std::string & operation,
        const std::string & info ) {
    const Time stop(now());
    const Duration duration(stop.time_since_epoch() - start.time_since_epoch());
    log.write( operation, info, duration );
}

} // namespace profiling
} // namespace pgg
