#pragma once

#include <pgg/request_info.h>
#include <pgg/query/mapper.h>
#include <pgg/query/helper.h>
#include <pgg/preprocessor.h>
#include <string>

namespace pgg {
namespace query {

template <typename Tag>
struct ValueWrapper {
    using Value = typename Tag::Value;
    Value value;
    ValueWrapper() : value() {}
    ValueWrapper(const Value & v) : value(v) {}
};

#define PGG_QUERY_ID(namespaceSeq, className, type) \
        PGG_GENERATE_NAMESPACE_SCOPE_HEADER(namespaceSeq)\
            struct className##Tag { typedef type Value; };\
            typedef ::pgg::query::ValueWrapper<className##Tag> className;\
        PGG_GENERATE_NAMESPACE_SCOPE_FOOTER(namespaceSeq)\
        \
        namespace pgg {\
        namespace query {\
            template<typename Base>\
            struct Helper<Base, PGG_GENERATE_NAMESPACE_CHAIN(namespaceSeq)::className> {\
                using FullClassName = PGG_GENERATE_NAMESPACE_CHAIN(namespaceSeq)::className;\
                template <typename MapperT>\
                void map(const MapperT & m) const { m.mapValue(v_.value, BOOST_STRINGIZE(className)); }\
                void set(const FullClassName & v) { v_ = v; }\
                FullClassName::Value get() const { return v_.value; }\
            private:\
                FullClassName v_;\
            };\
        }}

struct Date {
    using Value = boost::posix_time::ptime;
    Value value;
    Date() : value() {}
    explicit Date(const Value & v)
        : value(v)
    { }
    explicit Date(std::time_t t)
        : value(boost::posix_time::from_time_t(t))
    { }
};

template<typename Base>
struct Helper<Base, Date> {
    template <typename MapperT>
    void map(const MapperT & m) const { m.mapValue(d_.value, "date"); }
    void set(const Date & d) { d_ = d; }
    Base & date( const Date & d ) {
        d_ = d;
        return static_cast<Base&>(*this);
    }
private:
    Date d_;
};

template<typename Base>
struct Helper<Base, RequestInfo> {
    template <typename MapperT>
    void map(const MapperT & m) const {
        const auto tuple = boost::make_tuple(reqInfo_.requestId, reqInfo_.connectionId);
        m.mapValue(std::move(tuple), "requestInfo");
    }
    void set(const RequestInfo & reqInfo) {
        reqInfo_ = reqInfo;
    }
    Base & requestInfo( const RequestInfo & reqInfo ) {
        reqInfo_ = reqInfo;
        return static_cast<Base&>(*this);
    }
private:
    RequestInfo reqInfo_;
};

} // namespace query
} // namespace pgg
