#pragma once

#include <pgg/query/helper.h>
#include <pgg/query/traits.h>
#include <pgg/type_name.h>
#include <pgg/enumeration.h>
#include <pgg/preprocessor.h>
#include <vector>

namespace pgg {
namespace query {

typedef std::string ParameterPart;
typedef std::vector<ParameterPart> ParameterValues;
typedef std::set<std::string> ParameterValuesNames;

template <typename Final, typename T, typename T::Enum defVal =  T::defaultValue>
class Parameter : public Enumeration<T, defVal> {
public:
    typedef Enumeration<T, defVal> Base;
    typedef Parameter<Final, T, defVal> Inherited;
    typedef typename T::Filler Filler;

    Parameter(typename Base::Enum v = Base::defaultValue) : Base(v){}

    static const std::string & name() {
        static const std::string retval = pgg::details::stripNamespaces(
                pgg::details::typeName<Final>());
        return retval;
    }

    static const ParameterValuesNames & valueNames() {
        static const auto retval = createValuesNames();
        return retval;
    }

    template <typename Base >
    class Helper {
    public:
        void set( typename T::Enum arg ) { v = std::move(arg); }
        template <typename MapperT>
        void mapParameter( MapperT m ) const {
            m.mapParameter( v );
        }
    private:
        Parameter v;
    };
private:
    static ParameterValuesNames createValuesNames() {
        typename Filler::Map map;
        Filler().fill(map);
        ParameterValuesNames retval;
        for( const auto & i : map.right) {
            retval.insert(i.first);
        }
        return retval;
    }
};

#define PGG_DECLARE_QUERY_PARAMETER(namespaceSeq, Name, EnumHolder, defVal) \
    PGG_GENERATE_NAMESPACE_SCOPE_HEADER(namespaceSeq)\
    struct Name : public ::pgg::query::Parameter<Name, EnumHolder, defVal> {\
        Name(Enum v) : Inherited(v){}\
    };\
    PGG_GENERATE_NAMESPACE_SCOPE_FOOTER(namespaceSeq)\
    namespace pgg {\
    namespace query {\
        template <typename Base>\
        struct Helper<Base, PGG_GENERATE_NAMESPACE_CHAIN(namespaceSeq)::Name>\
                : public PGG_GENERATE_NAMESPACE_CHAIN(namespaceSeq)::Name::Helper<Base> {\
            template <typename T>\
            void mapParameter( T m ) const {\
                using Name = PGG_GENERATE_NAMESPACE_CHAIN(namespaceSeq)::Name;\
                Name::Helper<Base>::mapParameter( m );\
            }\
        };\
    }}

} // namespace query
} // namespace pgg
