#pragma once

#include <pgg/query/mapper.h>
#include <pgg/query/traits.h>
#include <pgg/chrono.h>

namespace pgg {
namespace query {

typedef std::string Text;
/**
 * Query interface
 */
struct Query {
    using EndpointType = Traits::EndpointType;
    using QueryPtr = boost::shared_ptr<Query>;
    virtual ~Query() {}
    virtual Text text() const = 0;
    virtual void mapValues(const Mapper & m) const = 0;
    virtual const char * name() const = 0;
    virtual Milliseconds timeout() const = 0;
    virtual bool debug() const = 0;
    virtual EndpointType endpointType() const = 0;
    virtual QueryPtr clone() const = 0;
};

} // namespace query
} // namespace pgg
