#pragma once

#include <pgg/error.h>

namespace pgg {
namespace query {
namespace repository {
namespace error {

enum Errors {
    ok,
    unresolved,
    unused,
    unregistered,
    unspecified,
    internal
};

class Category : public boost::system::error_category {
public:
    const char* name() const noexcept override {
        return "macs::pg::query::repository::error";
    }

    std::string message(int v) const override {
        switch(v) {
            case ok :
                return "no error";
            case unresolved :
                return "unresolved variables found";
            case unused :
                return "unused variables found";
            case unregistered :
                return "entity was not registered in application";
            case unspecified :
                return "entity is not specified in configuration";
            case internal :
                return "internal error";
            default:
                return "unknown error";
        }
    }
};

inline const error_code::error_category & getCategory() {
    static Category instance;
    return instance;
}

inline error_code::base_type make_error_code(Errors e) {
    return error_code::base_type(static_cast<int>(e), getCategory());
}

} // namespace error

typedef ::pgg::error_code ErrorCode;

} // namespace repository
} // namespace query
} // namespace pgg

namespace boost {
namespace system {

template <>
struct is_error_code_enum<pgg::query::repository::error::Errors> {
    static const bool value = true;
};

} // namespace system
} // namespace boost
