#pragma once

#include <pgg/query/repository/table.h>
#include <iostream>

namespace pgg {
namespace query {
namespace repository {

class ParametersTablePrinter {
    std::ostream & s;
public:
    ParametersTablePrinter(std::ostream & s) : s(s) {}
    typedef query::repository::ParametersTable Table;
    typedef typename Table::Item Item;

    void printItem( const Item & v ) const {
        s << "{ name:" << v.name() << " }" << std::endl;
    }

    void print( const Table & t ) const {
        for( const auto & v : t ) { printItem(v); }
    }
};

inline std::ostream & operator << (std::ostream & s, const ParametersTable & v ) {
    ParametersTablePrinter(s).print(v);
    return s;
}

class TablePrinter {
    std::ostream & s;
public:
    TablePrinter(std::ostream & s) : s(s) {}
    typedef query::repository::QueryTable Table;
    typedef typename Table::Item Item;

    void printItem( const Item & v ) const {
        s << "{ name:" << v.name()  << ", variables:[";
        const VariablesMap & map(v.variables());
        for(const auto & i : map) {
            s << '(' << i.first << ':' << i.second << ')';
        }
        s << "]}" << std::endl;
    }

    void print( const Table & t ) const {
        for( const auto & v : t ) { printItem(v); }
    }
};

inline std::ostream & operator << (std::ostream & s, const QueryTable & v ) {
    TablePrinter(s).print(v);
    return s;
}

} // namespace repository
} // namespace query
} // namespace pgg
