#pragma once

#include <pgg/query/body.h>
#include <pgg/enumeration.h>
#include <pgg/chrono.h>
#include <string>
#include <map>

namespace pgg {
namespace query {

struct __EndpointType{
    enum Enum {
        automatic,
        master,
        replica,
        noLagReplica,
        lagReplica
    };
    typedef Enum2String<Enum>::Map Map;
    void fill(Map & map) const {
#define ADD_ENUM_TO_MAP(name) map.insert(Map::value_type(name, #name))
        ADD_ENUM_TO_MAP(automatic);
        ADD_ENUM_TO_MAP(master);
        ADD_ENUM_TO_MAP(replica);
        ADD_ENUM_TO_MAP(noLagReplica);
        ADD_ENUM_TO_MAP(lagReplica);
#undef ADD_ENUM_TO_MAP
    }
    typedef __EndpointType Filler;
};

struct Traits {
    typedef Enumeration<__EndpointType, __EndpointType::automatic> EndpointType;
    typedef pgg::Milliseconds Milliseconds;
    typedef query::Body Body;
    struct Options {
        bool debug;
        bool rollback;
        Traits::Milliseconds timeout;
        EndpointType endpoint;
        Options() : debug(false), rollback(true), timeout(0){}
    };

    Options options;
    Body body;
};


typedef std::map<std::string, std::string> ParameterMap;
typedef std::map<std::string, ParameterMap> Parameters;
typedef std::map<std::string, Traits> TraitsMap;

} // namespace query
} // namespace pgg
