#pragma once

#include <boost/range/iterator_range.hpp>

#include <apq/row_iterator.hpp>

namespace pgg {

namespace database {
inline apq::row_iterator end() {
    return apq::row_iterator();
}
} // namespace database

inline bool endOfData(apq::row_iterator i) {
    return database::end() == i;
}

using DataRange = decltype(boost::make_iterator_range(database::end(), database::end()));

inline DataRange range(apq::row_iterator begin) {
    return boost::make_iterator_range(begin, database::end());
}

} // namespace pgg
