#pragma once

#include <pgg/service/uid_resolver.h>

namespace pgg {

class FakeUidResolver : public UidResolver, public UidResolverFactory {
public:
    FakeUidResolver(const std::string& connStr, const std::string& shardName)
        : connStr_(connStr), shardName_(shardName)
    {}

    void asyncGetConnInfo(const UidResolveParams&, OnResolve hook) const override {
        hook(boost::system::error_code(), {connStr_});
    }

    void asyncGetShardName(const UidResolveParams&, OnShardName hook) const override {
        hook(boost::system::error_code(), shardName_);
    }

    UidResolverPtr product(Credentials credentials, const RequestInfo&, UserType) const override {
        return std::make_shared<FakeUidResolver>(connStr_ + credentials.toString(), shardName_);
    }

private:
    std::string connStr_;
    std::string shardName_;
};

} // namespace pgg
