#pragma once

#include <pgg/service/resolver.h>
#include <pgg/request_info.h>

namespace pgg {

struct ShardResolveParams;

class ShardResolver {
public:
    using Id = sharpei::client::Shard::Id;
    using Params = ShardResolveParams;
    virtual ~ShardResolver() {}
    virtual void asyncGetConnInfo(const ShardResolveParams& params, OnResolve hook) const = 0;
    virtual void asyncGetShardName(const ShardResolveParams& params, OnShardName hook) const = 0;
    virtual void asyncGetShardStatus(const ShardResolveParams& params, OnShardInfo hook) const {
        asyncGetShardName(params, [h = std::move(hook)](error_code ec, std::string name){
            return h(std::move(ec), ShardInfo(std::move(name)));
        });
    }
};

struct ShardResolveParams {
    using EndpointType = query::Traits::EndpointType;
    using Id = ShardResolver::Id;
    Id shardId_;
    EndpointType endpointType_;
    bool force_;
    ShardResolveParams(const Id& id)
        : shardId_(id), endpointType_(EndpointType::master), force_(false)
    { }

    ShardResolveParams& endpointType(EndpointType v) { endpointType_ = v; return *this; }
    ShardResolveParams& force(bool v) { force_ = v; return *this; }
};

using ShardResolverPtr = std::shared_ptr<const ShardResolver>;

class ShardResolverFactory {
public:
    virtual ~ShardResolverFactory() {}
    virtual ShardResolverPtr product(Credentials credentials, const RequestInfo& requestInfo) const = 0;
};

using ShardResolverFactoryPtr = std::shared_ptr<const ShardResolverFactory>;

ShardResolverFactoryPtr createShardResolverFactory(const SharpeiParams& params);

ShardResolverPtr createShardResolver(Credentials credentials, sharpei::client::SharpeiClientPtr client);

ShardResolverFactoryPtr createFakeShardResolverFactory(const std::string& connStr, const std::string& shardName);

} //namespace pgg
