#pragma once

#include <pgg/service/uid_resolver.h>

namespace pgg {

class SharpeiUidResolver : public UidResolver {
public:
    SharpeiUidResolver(Credentials credentials, sharpei::client::SharpeiClientPtr client,
                       UserType userType = UserType::existing)
        : credentials(std::move(credentials)), client(std::move(client)), userType(userType)
    {}

    void asyncGetConnInfo(const UidResolveParams& p, OnResolve hook) const override {
        using namespace sharpei::client;
        const auto credentials = this->credentials;
        const auto handler = getConnInfoHandler<UidResolveParams>(hook, p, credentials);
        asyncGetConnInfoImpl(p, handler);
    }

    void asyncGetShardName(const UidResolveParams& p, OnShardName hook) const override {
        using sharpei::client::Shard;
        const auto handler = [=] (error_code error, Shard shard) {
            hook(error, std::move(shard.name));
        };
        asyncGetConnInfoImpl(p, handler);
    }

    void asyncGetShardStatus(const UidResolveParams& p, OnShardInfo hook) const override {
        asyncGetConnInfoImpl(p, getShardInfoHandler(std::move(hook)));
    }

private:
    Credentials credentials;
    sharpei::client::SharpeiClientPtr client;
    UserType userType;

    template <class Handler>
    void asyncGetConnInfoImpl(const UidResolveParams& p, Handler handler) const {
        using namespace sharpei::client;
        switch (userType) {
            case UserType::existing:
                client->asyncGetConnInfo(ResolveParams(p.userId_, Mode::All, p.force_), handler);
                break;
            case UserType::deleted:
                client->asyncGetDeletedConnInfo(ResolveParams(p.userId_, Mode::All, p.force_), handler);
                break;
            case UserType::organization:
                client->asyncGetOrgConnInfo(ResolveParams(p.userId_, Mode::All, p.force_), handler);
                break;
        }
    }
};

} // namespace pgg
