#pragma once

#include <pgg/service/sharpei_uid_resolver.h>

namespace pgg {

class SharpeiUidResolverFactory : public UidResolverFactory {
public:
    SharpeiUidResolverFactory(const SharpeiParams& params)
        : sharpeiParams_(params)
    {}

    UidResolverPtr product(Credentials credentials, const RequestInfo& requestInfo,
                           UidResolver::UserType userType = UidResolver::UserType::existing) const override {
        const sharpei::client::RequestInfo reqInfo {requestInfo.requestId, requestInfo.connectionId,
            requestInfo.clientType, requestInfo.userIp, requestInfo.requestId};
        using namespace sharpei::client;
        const auto sharpeiClient = createSharpeiClient(sharpeiParams_.httpClient, sharpeiParams_.settings,
            reqInfo);
        return std::make_shared<SharpeiUidResolver>(std::move(credentials), makeCached(sharpeiClient), userType);
    }

private:
    SharpeiParams sharpeiParams_;
};

} // namespace pgg
