#pragma once

#include <string>
#include <typeinfo>

namespace pgg {
namespace details {

std::string demangle(const char* name);

template <class T>
std::string typeName() {
    return demangle(typeid(T).name());
}

template <class T>
std::string typeName(const T& v) {
    return demangle(typeid(v).name());
}

std::string stripNamespaces( const std::string & name );

} // namespace details
} // namespace pgg
