#include <pgg/database/pool_factory.h>
#include <pgg/database/pool.h>
#include <apq/dns.hpp>

namespace pgg {

using namespace pgg::database;

ConnectionPoolPtr ConnectionPoolFactory::product() const {
    auto ios = ioService_ ?
            IoServicePtr(boost::make_shared<ExternalIoService>(*ioService_)) :
            IoServicePtr(boost::make_shared<IoServiceWithPool>(workersCount_)) ;

    if (dnsCacheTTL_ != Duration::zero()) {
        apq::dns_settings dnsSettings = { .cache_ttl = dnsCacheTTL_ };
        apq::setup_dns(ios->ios(), dnsSettings);
    }

    return boost::make_shared<ConnectionPool>(ios , limit_, settings_);
}

} // namespace pgg

