#include <pgg/database/statistic.h>
#include <pgg/database/pool.h>
#include <apq/connection_pool.hpp>

namespace pgg {

namespace statistic {

ConnectionPoolStats getPoolStats(const database::ConnectionPool& pool) {
    // convert ConnectionPool::Stats to ConnectionPoolStats
    database::ConnectionPool::Stats stats = pool.getStats();
    ConnectionPoolStats result;
    for (const auto& conn: stats) {
        ConnectionStats stat;
        stat.freeConnections = conn.second.free_connections;
        stat.busyConnections = conn.second.busy_connections;
        stat.pendingConnections = conn.second.pending_connections;
        stat.maxConnections = conn.second.max_connections;
        stat.queueSize = conn.second.queue_size;

        stat.averageRequestRoundtrip = std::chrono::microseconds(conn.second.average_request_roundtrip_usec);
        stat.averageRequestDbLatency = std::chrono::microseconds(conn.second.average_request_db_latency_usec);
        stat.averageWaitTime = std::chrono::microseconds(conn.second.average_wait_time_usec);

        stat.droppedTimedOut = conn.second.num_dropped_connections.timed_out;
        stat.droppedFailed = conn.second.num_dropped_connections.failed;
        stat.droppedBusy = conn.second.num_dropped_connections.busy;
        stat.droppedWithResult = conn.second.num_dropped_connections.with_result;
        result.emplace_back(conn.first, stat);
    }
    return result;
}

} // namespace statistic
} // namespace pgg
