#include <pgg/query/conf.h>
#include <internal/query_conf/parser.h>
#include <iterator>
#include <fstream>
#include <iostream>

namespace pgg {
namespace query {

void Configuration::loadFromSting( const std::string & text ) {
    conf::Entries e;
    conf::parseConfig(text, e);
    std::swap(e.queries, queries_);
    std::swap(e.parameters, parameters_);
}

void Configuration::loadFromFile( const std::string & fileName ) {
    if(fileName.empty()) {
        throw std::invalid_argument("Can not load query configuration - fileName is empty");
    }
    std::ifstream f(fileName.c_str());
    if(!f) {
        throw std::runtime_error("Can not load query configuration from " + fileName);
    }
    typedef std::istreambuf_iterator<char> Iter;
    const std::string s = std::string(Iter(f), Iter());
    if( s.empty() ) {
        throw std::runtime_error("Can not load query configuration from "
                + fileName + " - file is empty!");
    }
    f.close();
    loadFromSting( s );
}

} // namespace query
} // namespace pgg
