#include <pgg/service/sharpei_uid_resolver.h>
#include <pgg/service/sharpei_uid_resolver_factory.h>
#include <pgg/service/fake_uid_resolver.h>

namespace pgg {

UidResolverFactoryPtr createSharpeiUidResolverFactory(const SharpeiParams& params) {
    return std::make_shared<SharpeiUidResolverFactory>(params);
}

UidResolverFactoryPtr createFakeUidResolverFactory(const std::string& connString,
                                                   const std::string& shardName) {
    return std::make_shared<FakeUidResolver>(connString, shardName);
}

UidResolverPtr createSharpeiUidResolver(Credentials credentials, sharpei::client::SharpeiClientPtr client,
                                        UidResolver::UserType userType) {
    return std::make_shared<SharpeiUidResolver>(std::move(credentials), std::move(client), userType);
}

UidResolverPtr createFakeUidResolver(const std::string& connStr, const std::string& shardName) {
    return std::make_shared<FakeUidResolver>(connStr, shardName);
}

} // namespace pgg
