#include <pgg/type_name.h>
#include <boost/core/demangle.hpp>

namespace pgg {
namespace details {

std::string demangle(const char* name) {
    return boost::core::demangle(name);
}

std::string stripNamespaces( const std::string & name ) {
    std::string::size_type pos = name.find_last_of(':');
    if(pos != std::string::npos) {
        ++pos;
        return pos < name.length() ? name.substr(pos) : name;
    }
    return name;
}

} // namespace details
} // namespace pgg
