#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
prefix="http.requests."

function run()
{
    timetail -t imap -n 60 $1 | head -n -1 | tr '[:upper:]' '[:lower:]' | \
    awk -F '[ =":?/{}]' -v prefix=$prefix -v ts=$ts '
        @include "/usr/share/yandex-mail-common/metrics-util.awk"

        /event=start/ {
            url = ""
            conn = ""
            for (i = 1; i+2 <= NF; ++i) {
                if ($i == "uri") {
                    url = $(i+2)
                }
                if ($i == "conn") {
                    conn = $(i+1)
                }
            }
            gsub("\\.", "_", url)
            host_by_conn[conn] = url
        }
        /event=fin/ {
            status = ""
            conn = ""
            for (i = 1; i+2 <= NF; ++i) {
                if ($i == "status") {
                    status = $(i+1)
                }
                if ($i == "conn") {
                    conn = $(i+1)
                }
                if ($i == "tm") {
                    tm = $(i+5)
                }
                if ($i == "attempt") {
                    attempt = $(i+1)
                }
            }
            host = host_by_conn[conn]
            if (length(host) > 0) {
                host_status[host "." status]++
                host_attempt[host "." attempt]++
                collect_timings(tm, host, host_tm)
            }
        }
        END {
            for (i in host_status) {
                delim_pos = index(i, ".")
                status = substr(i, delim_pos + 1)
                host = substr(i, 1, delim_pos - 1)
                print prefix "status." status, host_status[i], ts, host
            }
            for (i in host_attempt) {
                delim_pos = index(i, ".")
                attempt = substr(i, delim_pos + 1)
                host = substr(i, 1, delim_pos - 1)
                print prefix "attempt." attempt, host_attempt[i], ts, host
            }
            for (host in host_tm) {
                print prefix "timings", "[" host_tm[host] "]", ts, host
            }
        }'
}

run /app/log/api.log
run /app/log/app.log # for blackbox requests